/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.activestate;

import com.cobblemon.mod.common.api.pokemon.effect.ShoulderEffect;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0001@B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b#\u0010\u0003J\u0017\u0010&\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020\u00062\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b*\u0010+R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010,\u001a\u0004\b\u0007\u0010-\"\u0004\b.\u0010/R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0005\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\b\u00100\u001a\u0004\b5\u00102\"\u0004\b6\u00104R*\u00108\u001a\n 7*\u0004\u0018\u00010\u00040\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00100\u001a\u0004\b9\u00102\"\u0004\b:\u00104R\u001c\u0010<\u001a\u0004\u0018\u00010;8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lcom/cobblemon/mod/common/pokemon/activestate/ShoulderedState;", "Lcom/cobblemon/mod/common/pokemon/activestate/ActivePokemonState;", "<init>", "()V", "Ljava/util/UUID;", "playerUUID", "", "isLeftShoulder", "pokemonUUID", "(Ljava/util/UUID;ZLjava/util/UUID;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_2960;", "getIcon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/class_2960;", "Lnet/minecraft/class_2487;", "nbt", "writeToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "readFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "Lcom/google/gson/JsonObject;", "json", "writeToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "readFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "Lnet/minecraft/class_9129;", "buffer", "", "writeToBuffer", "(Lnet/minecraft/class_9129;)V", "readFromBuffer", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "recall", "Lnet/minecraft/class_3222;", "player", "removeShoulderEffects", "(Lnet/minecraft/class_3222;)V", "isShoulderedPokemon", "(Lnet/minecraft/class_2487;)Z", "isStillShouldered", "(Lnet/minecraft/class_3222;)Z", "Z", "()Z", "setLeftShoulder", "(Z)V", "Ljava/util/UUID;", "getPlayerUUID", "()Ljava/util/UUID;", "setPlayerUUID", "(Ljava/util/UUID;)V", "getPokemonUUID", "setPokemonUUID", "kotlin.jvm.PlatformType", "stateId", "getStateId", "setStateId", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonState.kt\ncom/cobblemon/mod/common/pokemon/activestate/ShoulderedState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1#2:251\n1869#3,2:252\n*S KotlinDebug\n*F\n+ 1 PokemonState.kt\ncom/cobblemon/mod/common/pokemon/activestate/ShoulderedState\n*L\n218#1:252,2\n*E\n"})
public final class ShoulderedState
extends ActivePokemonState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isLeftShoulder;
    public UUID playerUUID;
    public UUID pokemonUUID;
    private UUID stateId;
    @Nullable
    private final PokemonEntity entity;
    @NotNull
    public static final String ID = "shouldered";
    @NotNull
    private static final Codec<ShoulderedState> CODEC;

    public ShoulderedState() {
        super(null);
        this.stateId = UUID.randomUUID();
    }

    public final boolean isLeftShoulder() {
        return this.isLeftShoulder;
    }

    public final void setLeftShoulder(boolean bl) {
        this.isLeftShoulder = bl;
    }

    @NotNull
    public final UUID getPlayerUUID() {
        UUID uUID = this.playerUUID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playerUUID");
        return null;
    }

    public final void setPlayerUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.playerUUID = uUID;
    }

    @NotNull
    public final UUID getPokemonUUID() {
        UUID uUID = this.pokemonUUID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pokemonUUID");
        return null;
    }

    public final void setPokemonUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.pokemonUUID = uUID;
    }

    public final UUID getStateId() {
        return this.stateId;
    }

    public final void setStateId(UUID uUID) {
        this.stateId = uUID;
    }

    public ShoulderedState(@NotNull UUID playerUUID, boolean isLeftShoulder, @NotNull UUID pokemonUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)pokemonUUID, (String)"pokemonUUID");
        this();
        this.isLeftShoulder = isLeftShoulder;
        this.setPlayerUUID(playerUUID);
        this.setPokemonUUID(pokemonUUID);
    }

    @Override
    @Nullable
    public PokemonEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public class_2960 getIcon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        String suffix = this.isLeftShoulder ? "left" : "right";
        return MiscUtilsKt.cobblemonResource("textures/gui/party/party_icon_shoulder_" + suffix + ".png");
    }

    @Override
    @NotNull
    public class_2487 writeToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.writeToNBT(nbt);
        nbt.method_10556("StateShoulder", this.isLeftShoulder);
        nbt.method_25927("PlayerUUID", this.getPlayerUUID());
        nbt.method_25927("StateId", this.stateId);
        nbt.method_25927("PokemonUUID", this.getPokemonUUID());
        return nbt;
    }

    @Override
    @NotNull
    public PokemonState readFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readFromNBT(nbt);
        this.isLeftShoulder = nbt.method_10577("StateShoulder");
        UUID uUID = nbt.method_25926("PlayerUUID");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.setPlayerUUID(uUID);
        this.stateId = nbt.method_25926("StateId");
        UUID uUID2 = nbt.method_25926("PokemonUUID");
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    @Nullable
    public JsonObject writeToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        super.writeToJSON(json);
        json.addProperty("StateShoulder", Boolean.valueOf(this.isLeftShoulder));
        json.addProperty("PlayerUUID", this.getPlayerUUID().toString());
        json.addProperty("StateId", this.stateId.toString());
        json.addProperty("PokemonUUID", this.getPokemonUUID().toString());
        return json;
    }

    @Override
    @NotNull
    public PokemonState readFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        super.readFromJSON(json);
        this.isLeftShoulder = json.get("StateShoulder").getAsBoolean();
        UUID uUID = UUID.fromString(json.get("PlayerUUID").getAsString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        this.setPlayerUUID(uUID);
        this.stateId = UUID.fromString(json.get("StateId").getAsString());
        UUID uUID2 = UUID.fromString(json.get("PokemonUUID").getAsString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    public void writeToBuffer(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.writeToBuffer(buffer);
        buffer.method_52964(this.isLeftShoulder);
        buffer.method_10797(this.getPlayerUUID());
        buffer.method_10797(this.stateId);
        buffer.method_10797(this.getPokemonUUID());
    }

    @Override
    @NotNull
    public PokemonState readFromBuffer(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.readFromBuffer(buffer);
        this.isLeftShoulder = buffer.readBoolean();
        UUID uUID = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
        this.setPlayerUUID(uUID);
        this.stateId = buffer.method_10790();
        UUID uUID2 = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"readUUID(...)");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    public void recall() {
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer(this.getPlayerUUID());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        class_2487 nbt = this.isLeftShoulder ? player.method_7356() : player.method_7308();
        Intrinsics.checkNotNull((Object)nbt);
        if (this.isShoulderedPokemon(nbt)) {
            class_1937 class_19372 = player.method_37908();
            Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"level(...)");
            class_243 class_2432 = player.method_19538();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
            class_3414 class_34142 = class_3417.field_26956;
            Intrinsics.checkNotNullExpressionValue((Object)class_34142, (String)"CANDLE_FALL");
            WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, class_34142, null, 0.0f, 0.0f, 28, null);
            if (this.isLeftShoulder) {
                player.method_7273(new class_2487());
            } else {
                player.method_7345(new class_2487());
            }
            this.removeShoulderEffects(player);
        }
    }

    private final void removeShoulderEffects(class_3222 player) {
        block3: {
            Pokemon partyPokemon;
            Object object;
            Object v0;
            block2: {
                Iterable iterable = PlayerExtensionsKt.party(player);
                for (Object t : iterable) {
                    Pokemon pokemon = (Pokemon)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)pokemon.getUuid(), (Object)this.getPokemonUUID())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((object = (partyPokemon = (Pokemon)v0)) == null || (object = ((Pokemon)object).getForm()) == null || (object = ((FormData)object).getShoulderEffects()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShoulderEffect effect = (ShoulderEffect)element$iv;
                boolean bl = false;
                effect.removeEffect(partyPokemon, player, this.isLeftShoulder);
            }
        }
    }

    private final boolean isShoulderedPokemon(class_2487 nbt) {
        return CompoundTagExtensionsKt.isPokemonEntity(nbt) && Intrinsics.areEqual((Object)nbt.method_10562("Pokemon").method_10562("State").method_25926("StateId"), (Object)this.stateId);
    }

    public final boolean isStillShouldered(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2487 class_24872 = this.isLeftShoulder ? player.method_7356() : player.method_7308();
        Intrinsics.checkNotNull((Object)class_24872);
        return this.isShoulderedPokemon(class_24872);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.STRING.fieldOf("StateType").forGetter(ShoulderedState::CODEC$lambda$0$0), (App)Codec.BOOL.fieldOf("StateShoulder").forGetter(arg_0 -> ShoulderedState.CODEC$lambda$0$1((KMutableProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)class_4844.field_46588.fieldOf("PlayerUUID").forGetter(arg_0 -> ShoulderedState.CODEC$lambda$0$2((KMutableProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)class_4844.field_46588.fieldOf("StateId").forGetter(arg_0 -> ShoulderedState.CODEC$lambda$0$3((KMutableProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)class_4844.field_46588.fieldOf("PokemonUUID").forGetter(arg_0 -> ShoulderedState.CODEC$lambda$0$4((KMutableProperty1)Companion.CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)instance, ShoulderedState::CODEC$lambda$0$5);
    }

    private static final String CODEC$lambda$0$0(ShoulderedState it) {
        return ID;
    }

    private static final Boolean CODEC$lambda$0$1(KMutableProperty1 $tmp0, ShoulderedState p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final UUID CODEC$lambda$0$2(KMutableProperty1 $tmp0, ShoulderedState p0) {
        return (UUID)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final UUID CODEC$lambda$0$3(KMutableProperty1 $tmp0, ShoulderedState p0) {
        return (UUID)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final UUID CODEC$lambda$0$4(KMutableProperty1 $tmp0, ShoulderedState p0) {
        return (UUID)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ShoulderedState CODEC$lambda$0$5(String string, Boolean isLeftShoulder, UUID playerUuid, UUID stateId, UUID pokemonUuid) {
        Intrinsics.checkNotNull((Object)playerUuid);
        Intrinsics.checkNotNull((Object)isLeftShoulder);
        boolean bl = isLeftShoulder;
        Intrinsics.checkNotNull((Object)pokemonUuid);
        ShoulderedState state = new ShoulderedState(playerUuid, bl, pokemonUuid);
        state.stateId = stateId;
        return state;
    }

    @NotNull
    public static final Codec<ShoulderedState> getCODEC() {
        return Companion.getCODEC();
    }

    static {
        Codec codec = RecordCodecBuilder.create(ShoulderedState::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/pokemon/activestate/ShoulderedState$Companion;", "", "<init>", "()V", "", "ID", "Ljava/lang/String;", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/pokemon/activestate/ShoulderedState;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "getCODEC$annotations", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<ShoulderedState> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

